<?php
session_start();
require_once('./config/autoload.php');
$error_message = '';
$max = 4000 * 1024;
if(isset($_POST['convert'])){
  $convert_to_format = $_POST['format'];
  $quality = $_POST['quality'];
  $size = $_POST['size'];
  $upload = new Uploader(UPLOAD_PATH);
  $set_max = $upload->setMax($max);
  if($set_max){
     $upload_image = $upload->upload();
     if($upload_image){
         $image_converter = new ImageConverter(['format'=>$convert_to_format, 'quality'=>$quality, 'size'=>$size, 'image_name'=>$upload_image, 'output_folder'=>OUTPUT_PATH]);
         $convert = $image_converter->convert();
         if($convert){
             $converted_file_name = explode('\\', $convert);
             $converted_file_name = end($converted_file_name);
             $message = "Your Image has been successfully converted to {$converted_file_name}";
            unlink($upload_image);
         }else{
             $error[] = 'Converting Image Failed';
         }
     }else{
       $errors = $upload->getErrors();
     }
  }else{
    $errors = $upload->getErrors();
  }
}
?>
<!DOCTYPE html>
<html>
  <head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" >
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="Author" content="Aleks Nyombi">
    <meta name="keywords" content="online media converter, online video converter, simple media converter, covert images from one format to the other, resize images, change image quality">
    <link rel="stylesheet" href="./css/style.css">
      <link rel="stylesheet" href="./css/font-awesome.css">
      <!-- <link href="https://fonts.googleapis.com/css?family=Open+Sans:300i,400,600i" rel="stylesheet"> -->
    <title>Media Converter-convert your image from any format to the other</title>
  </head>
  <body>
    <div class="header">
      <div class="navbar">
        <a href="index.php" class="brand">Media Converter</a>
        <ul class="nav">
          <li class="nav-link"><a href="index.php" class="active">Convert Images</a></li>
          <li class="nav-link"><a href="about.php">About Us</a></li>
        </ul>
        <button class="nav-toggler"><span><i class="fa fa-bars fa-3x"></i></span></button>
        <div class="clear-fix"></div>
      </div>
    </div>
<!--    main body-->
<div class="container">
    <h1>Upload your Image to convert in a few seconds</h1>
    <div class="wrapper">

        
             <div class="main">
                 <form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="post" enctype="multipart/form-data" id="form">
                     <input type="hidden" name="MAX_FILE_SIZE" value="<?php echo $max;?>">
                     <div class="form-group">
                         <label for="file">Choose The Image To Convert:</label>
                         <input type="file" name="filename" id="filename" required>
                     </div>
                     <div class="form-group">
                         <label for="formart">Convert To:</label>
                         <select name="format" id="format" class="form-control" required>
                             <option value="">==Select Image Format==</option>
                             <option value="jpeg">JPEG</option>
                             <option value="jpg">JPG</option>
                             <option value="png">PNG</option>
                             <option value="webp">WEBP</option>
                             <option value="gif">GIF</option>
                         </select>
                     </div>
                     <div class="form-group">
                         <label for="quality">Image Quality:</label>
                         <select name="quality" id="quality" class="form-control" required>
                             <option value="">==Select Image Quality==</option>
                             <option value="high">High Quality</option>
                             <option value="normal">Normal Quality</option>
                         </select>
                     </div>
                     <div class="form-group">
                         <label for="size">Size:</label>
                         <select name="size" id="size" class="form-control">
                             <option value="original">Original Size</option>
                             <option value="xtralarge">Extra Large</option>
                             <option value="large">Large</option>
                             <option value="medium">Medium</option>
                             <option value="small">Small</option>
                             <option value="xsmall">Extra Small</option>
                         </select>
                     </div>
                     <div class="form-group convert-button">
                         <input class="btn" id="convert-btn" type="submit" value="Convert Now" name="convert">
                     </div>

                 </form>
             </div>
        <div class="output-area">
            <div class="output">
                <?php
                if(isset($error)){
                ?>
                 <div class="errors">
                        <?php
                        foreach ($error as $err){
                            echo $err;
                        }
                        ?>
                    </div>
                <?php
                }elseif(isset($errors)){
                    ?>
                    <div class="errors">
                        <?php
                        foreach ($errors as $error){
                            echo $error;
                        }
                        ?>
                    </div>
                    <?php
                }elseif(isset($message)) {
                    ?>
                    <div class="message">
                        <?php echo $message; ?>
                    </div>

                    <a class="download-link" href="download.php?file=<?php echo $convert; ?>">Download Image <i class="fa fa-download"></i></a>
                    <?php
                }elseif(isset($_GET['message'])){
                    ?>
                    <div class="alert-primary">
                        <?php echo $_GET['message']; ?>
                    </div>

                <?php
                }else{
                    ?>
                    
                    <div class="spinner d-none" id="spinner">
                        <div class="rect1"></div>
                        <div class="rect2"></div>
                        <div class="rect3"></div>
                        <div class="rect4"></div>
                        <div class="rect5"></div>
                    </div>
                   
                    <?php
                }
                ?>
            </div>

        </div>
    </div>

<!-- /main body end-->
    <!--  footer-->
    <div class="footer">
      <div class="footer-info">
        <div class="contacts">
            <h4>Contact-Us</h4>
            <p>Call: <i>+1 888-452-1505</i></p>
            <p>Email: <i>imagecoverter@info.com</i></p>
        </div>
        <div class="share">
            <h4>Share Our Website</h4>
            <ul class="social">
               <li class="social-link"><a href="https://www.facebook.com/"><i class="fa fa-facebook-square fa-3x"></i></a></li>
               <li class="social-link"><a href="https://twitter.com"><i class="fa fa-twitter-square fa-3x"></i></a></li>
               <li class="social-link"><a href="https://www.instagram.com"><i class="fa fa-instagram fa-3x"></i></a></li>
               <li class="social-link"><a href="https://plus.google.com"><i class="fa fa-google-plus-square fa-3x"></i></a></li>
            </ul>
        </div>
        <div class="our-products">
            <h4>Our Products</h4>
            <ul class="products">
                <li class="product-link"><a href="#">Image Coverter</a></li>
                <li class="product-link"><a href="#">Lorem ipsum.</a></li>
            </ul>
        </div>
      </div>
      <div class="footer-label">
        <p>&copy;<?php echo date('Y'); ?> Image Converter | Developed By Alex Nyombi</p>
      </div>
    </div>
</div>
<!--  /footer end -->
    <script src="./js/index.js"></script>
  </body>
</html